<?php
// Paul Mason © All Rights Reserved.
// paul@paulmason.name
// http://paulmason.name/blog/item/search-engine-friendly-sef-urls-for-virtuemart

function VirtuemartBuildRoute(&$query) {
  $db =& JFactory::getDBO();
	$segments = array();
  $category_id = (isset($query['category_id']))? $query['category_id'] : '';
  $product_id = (isset($query['product_id']))? $query['product_id'] : '';
  $manufacturer_id = (isset($query['manufacturer_id']))? $query['manufacturer_id'] : '';
  
  // category
  if (isset($query['page']) && $category_id) {
    if ($query['page'] == 'shop.browse') {

      //lookup category name set as segment
      $sql = "SELECT category_name FROM #__vm_category WHERE category_id = " . $category_id;
      $db->setQuery($sql);
      $category_name = $db->loadResult();
      if (strlen($category_name)) {
        $category_name = strtolower($category_name);
        $category_name = str_replace(' ', '-', $category_name);
        $category_name = str_replace('/', '-', $category_name);
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $category_name = str_replace($entities, '', urlencode($category_name));
        $segments[] = $category_name;
      }

      unset($query['page']);
      unset($query['category_id']);
    }
  }
  
  // manufacturer
  if (isset($query['page']) && $manufacturer_id) {
    if ($query['page'] == 'shop.browse') {

      //lookup category name set as segment
      $sql = "SELECT mf_name FROM #__vm_manufacturer WHERE manufacturer_id = " . $manufacturer_id;
      $db->setQuery($sql);
      $manufacturer_name = $db->loadResult();
      if (strlen($manufacturer_name)) {
        $manufacturer_name = strtolower($manufacturer_name);
        $manufacturer_name = str_replace(' ', '-', $manufacturer_name);
        $manufacturer_name = str_replace('/', '-', $manufacturer_name);
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $manufacturer_name = str_replace($entities, '', urlencode($manufacturer_name));
        $segments[] = $manufacturer_name;
      }

      unset($query['page']);
      unset($query['manufacturer_id']);
    }
  }

  // product details
  if (isset($query['page']) && $product_id) {
    if ($query['page'] == 'shop.product_details') {
    
      //prevent duplicate urls by chosing the category id with the highest list order
      $sql = "SELECT #__vm_category.category_id
              FROM #__vm_product
                INNER JOIN #__vm_product_category_xref 
                  ON (#__vm_product.product_id = #__vm_product_category_xref.product_id)
                INNER JOIN #__vm_category 
                  ON (#__vm_category.category_id = #__vm_product_category_xref.category_id)
              WHERE (#__vm_product.product_id = " . $product_id . "
                AND #__vm_category.category_publish = 'Y')
              ORDER BY #__vm_category.list_order ASC
              LIMIT 0,1";
      $db->setQuery($sql);
      $category_id = $db->loadResult();

      //lookup category name set as url segment
      $sql = "SELECT category_name
                FROM #__vm_category
                WHERE category_id = " . $category_id;
      $db->setQuery($sql);
      $category_name = $db->loadResult();
      if (strlen($category_name)) {
        $category_name = strtolower($category_name);
        $category_name = str_replace(' ', '-', $category_name);
        $segments[] = $category_name;
      }

      //lookup product name and set as url segment
      $sql = "SELECT product_name FROM #__vm_product WHERE product_id = " . $product_id;
      $db->setQuery($sql);
      $product_name = $db->loadResult();
      if (strlen($product_name)) {
        $product_name = strtolower($product_name);
        $product_name = str_replace(' ', '-', $product_name);
        $product_name = str_replace('/', '-', $product_name);
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $product_name = str_replace($entities, '', urlencode($product_name));        
        $segments[] = $product_name;
      }

      if (isset($query['flypage'])) unset($query['flypage']);
      unset($query['page']);
      unset($query['product_id']);
      unset($query['category_id']);
      unset($query['manufacturer_id']);

    }
  }
  
  // unique id
  $unique_id = (strlen($category_id)) ? $category_id : '';
  $unique_id .= (strlen($product_id)) ? "-" . $product_id : '';
  if (strlen($manufacturer_id && !strlen($unique_id))) {
    $unique_id = "m" . $manufacturer_id;
  } 


  $segments[] = $unique_id;

  unset($query['option']);
	$query['option'] = 'com_virtuemart';
	return $segments;
}

function VirtueMartParseRoute($segments) {
  
  $vars = array();
  $segment_count = count($segments);
  $category_id = '';
  $product_id = '';
  
  // categories
  if ($segment_count == 2) {
    if (strstr($segments[1], "m")) { // manufacturer
      $vars['manufacturer_id'] = str_replace('m', '', $segments[1]);
    } else { // category
      $vars['category_id'] = $segments[1];
    }
    $vars['page'] = 'shop.browse';
  }

  // product details
  if ($segment_count == 3) {
    $vars['page'] = 'shop.product_details';
    list($category_id, $product_id) = explode(":", $segments[2]);
    $vars['product_id'] = $product_id;
  }

  return $vars;
}


?>